<%@ Page language="c#" Codebehind="collections.aspx.cs" AutoEventWireup="false" Inherits="Orciid.collections" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title runat="server" id="PageTitle">Manage Collections</title>
		<meta name="GENERATOR" content="Microsoft Visual Studio 7.0">
		<meta name="CODE_LANGUAGE" content="C#">
		<meta name="vs_defaultClientScript" content="JavaScript">
		<meta name="vs_targetSchema" content="http://schemas.microsoft.com/intellisense/ie5">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<h1 id="Heading" runat="server">Manage Collections</h1>
			<H2 id="ManageCollectionHeading" runat="server">Manage collection</H2>
			<ul>
				<asp:Repeater id="CollectionRepeater" runat="server">
					<ItemTemplate>
						<li>
							<a href='collection.aspx?id=<%# DataBinder.Eval(Container, "DataItem.ID") %>'>
								<%# DataBinder.Eval(Container, "DataItem.Title") %>
							</a>&nbsp;(<%# GetCollectionTypeLabel((Orciid.Core.CollectionType)DataBinder.Eval(Container, "DataItem.Type")) %>)
						</li>
					</ItemTemplate>
				</asp:Repeater>
			</ul>
			<asp:Panel id="CreatePanel" runat="server">
				<H2 id="CreateNewCollectionHeading" runat="server">Create new collection</H2>
				<TABLE cellSpacing="0" cellPadding="3" border="0">
					<TR>
						<TD vAlign="top"><SPAN id="TypeSpan" runat="server">Type:</SPAN></TD>
						<TD vAlign="top">
							<asp:DropDownList id="TypeDropDownList" runat="server"></asp:DropDownList></TD>
					</TR>
					<TR>
						<TD vAlign="top"><SPAN id="TitleSpan" runat="server">Title:</SPAN></TD>
						<TD vAlign="top">
							<asp:TextBox id="TitleTextBox" runat="server" Columns="50"></asp:TextBox></TD>
					</TR>
					<TR>
						<TD vAlign="top"><SPAN id="DescriptionSpan" runat="server">Description:</SPAN></TD>
						<TD vAlign="top">
							<asp:TextBox id="DescriptionTextBox" runat="server" Columns="50" TextMode="MultiLine" Rows="4"></asp:TextBox></TD>
					</TR>
					<TR>
						<TD vAlign="top"><SPAN id="ResourcePathSpan" runat="server">Resource Path:</SPAN></TD>
						<TD vAlign="top">
							<asp:TextBox id="ResourcePathTextBox" runat="server" Columns="50"></asp:TextBox></TD>
					</TR>
					<TR>
						<TD vAlign="top"></TD>
						<TD vAlign="top">
							<asp:Button id="CreateButton" runat="server" Text="Create"></asp:Button></TD>
					</TR>
				</TABLE>
				<H3>&nbsp;</H3>
				<H3 id="AddSpecialCollectionsHeading" runat="server">Add special collections</H3>
				<P>
					<asp:LinkButton id="AddNIXCollectionLinkButton" runat="server">NASA Image eXchange (NIX)</asp:LinkButton></P>
			</asp:Panel>
			<P>
				<asp:Panel id="CollectionGroupPanel" runat="server">
					<H2 id="CollectionGroupsHeading" runat="server">Collection Groups</H2>
					<P></P>
					<P>
						<TABLE id="Table1" cellSpacing="0" cellPadding="3" border="0">
							<TR>
								<TD rowSpan="3">
									<asp:ListBox id="CollectionGroupListBox" runat="server" Rows="10"></asp:ListBox></TD>
								<TD><SPAN id="AddNewSpan" runat="server">Add new:</SPAN></TD>
								<TD>
									<asp:TextBox id="AddNewCollectionGroupTextBox" runat="server"></asp:TextBox></TD>
								<TD>
									<asp:Button id="AddNewCollectionGroupButton" runat="server" Text="Add"></asp:Button></TD>
							</TR>
							<TR>
								<TD><SPAN id="RenameToSpan" runat="server">Rename to:</SPAN></TD>
								<TD>
									<asp:TextBox id="RenameCollectionGroupTextBox" runat="server"></asp:TextBox></TD>
								<TD>
									<asp:Button id="RenameCollectionGroupButton" runat="server" Text="Rename"></asp:Button></TD>
							</TR>
							<TR>
								<TD colSpan="3">
									<asp:Button id="RemoveCollectionGroupButton" runat="server" Text="Remove"></asp:Button></TD>
							</TR>
						</TABLE>
					</P>
					<P>
				</asp:Panel></P>
		</form>
	</body>
</HTML>
