using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class favorites : PageTemplate.OrciidPage
	{
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl NoneSelected;
		protected System.Web.UI.HtmlControls.HtmlGenericControl PleaseBrowse;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			Orciid.Core.User user = Orciid.Core.User.CurrentUser();
			if (user != null)
			{
				ImageIdentifier[] favorites = user.GetFavoriteImages();
				if (favorites.Length > 0)
				{
					Session["LastSearchResult"] = new ResultPageOptions(
						GetLocalString(this, "FavoriteImages", "Favorite Images"), 
						null, null, favorites);
					Response.Redirect("result.aspx"); 
				}
			}
		}

		public override string GetHighlightedMenuItem()
		{
			return "MyMDID_Favorites";
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return Orciid.Core.User.HasPrivilegeOnAny('C', user, Privilege.ReadCollection);
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion
	}
}
