<%@ Page language="c#" Codebehind="transactionlog.aspx.cs" AutoEventWireup="false" Inherits="Orciid.transactionlog" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title runat="server" id="PageTitle">Transaction Log</title>
		<meta name="GENERATOR" content="Microsoft Visual Studio 7.0">
		<meta name="CODE_LANGUAGE" content="C#">
		<meta name="vs_defaultClientScript" content="JavaScript">
		<meta name="vs_targetSchema" content="http://schemas.microsoft.com/intellisense/ie5">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<h1 id="Heading" runat="server">Transaction Log</h1>
			<p><span id="EventTypeSpan" runat="server">Event type:</span>
				<asp:DropDownList id="EventTypeDropDownList" runat="server"></asp:DropDownList></p>
			<P><span id="DateRangeFromSpan" runat="server">Date range from:</span>
				<asp:TextBox id="DateRangeFromTextBox" runat="server" Columns="10"></asp:TextBox>
				<span id="DateRangeUntilSpan" runat="server">until</span>
				<asp:TextBox id="DateRangeUntilTextBox" runat="server" Columns="10"></asp:TextBox></P>
			<P>
				<asp:Button id="ShowButton" runat="server" Text="Show Events"></asp:Button>&nbsp;
				<asp:Button id="DeleteButton" runat="server" Text="Delete Events"></asp:Button>&nbsp;</P>
			<P>
				<asp:DataGrid id="EventsDataGrid" runat="server" AutoGenerateColumns="False" EnableViewState="False"
					CellPadding="3" GridLines="Vertical">
					<AlternatingItemStyle CssClass="DataGridItemAlt"></AlternatingItemStyle>
					<ItemStyle CssClass="DataGridItem"></ItemStyle>
					<HeaderStyle CssClass="DataGridHeader"></HeaderStyle>
					<Columns>
						<asp:TemplateColumn>
							<HeaderTemplate>
								<span id="IdHeadingSpan" runat="server">ID</span>
							</HeaderTemplate>
							<ItemTemplate>
								<asp:Label runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.ID") %>'>
								</asp:Label>
							</ItemTemplate>
						</asp:TemplateColumn>
						<asp:TemplateColumn>
							<HeaderTemplate>
								<span id="UserHeadingSpan" runat="server">User</span>
							</HeaderTemplate>
							<ItemTemplate>
								<asp:Label runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.UserID") %>'>
								</asp:Label>
							</ItemTemplate>
						</asp:TemplateColumn>
						<asp:TemplateColumn>
							<HeaderTemplate>
								<span id="TimeHeadingSpan" runat="server">Time</span>
							</HeaderTemplate>
							<ItemTemplate>
								<asp:Label runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.EventTime") %>'>
								</asp:Label>
							</ItemTemplate>
						</asp:TemplateColumn>
						<asp:TemplateColumn>
							<HeaderTemplate>
								<span id="EventHeadingSpan" runat="server">Event</span>
							</HeaderTemplate>
							<ItemTemplate>
								<asp:Label runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Title") %>'>
								</asp:Label>
							</ItemTemplate>
						</asp:TemplateColumn>
						<asp:TemplateColumn>
							<HeaderTemplate>
								<span id="DataHeadingSpan" runat="server">Data</span>
							</HeaderTemplate>
							<ItemTemplate>
								<asp:Label runat="server" Text='<%# DataBinder.Eval(Container, "DataItem.Data", "<pre>{0}</pre>") %>'>
								</asp:Label>
							</ItemTemplate>
						</asp:TemplateColumn>
					</Columns>
				</asp:DataGrid></P>
		</form>
	</body>
</HTML>
