using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Orciid.Core;

namespace Orciid
{
	public class transactionlog : PageTemplate.OrciidPage
	{
		protected System.Web.UI.WebControls.DropDownList EventTypeDropDownList;
		protected System.Web.UI.WebControls.TextBox DateRangeFromTextBox;
		protected System.Web.UI.WebControls.TextBox DateRangeUntilTextBox;
		protected System.Web.UI.WebControls.DataGrid EventsDataGrid;
		protected System.Web.UI.HtmlControls.HtmlGenericControl Heading;
		protected System.Web.UI.HtmlControls.HtmlGenericControl EventTypeSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl DateRangeFromSpan;
		protected System.Web.UI.HtmlControls.HtmlGenericControl DateRangeUntilSpan;
		protected System.Web.UI.WebControls.Button DeleteButton;
		protected System.Web.UI.WebControls.Button ShowButton;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			if (!IsPostBack)
			{
				ArrayList titles = new ArrayList(TransactionLog.Instance.GetTitles());
				titles.Insert(0, GetLocalString(this, "ALL", "[ALL]"));
				EventTypeDropDownList.DataSource = titles;
				EventTypeDropDownList.DataBind();
				DateTime from = DateTime.Now - TimeSpan.FromDays(1);
				DateRangeFromTextBox.Text = from.ToShortDateString();
				DateRangeUntilTextBox.Text = DateTime.Now.ToShortDateString();
			}

			string confirmdeletemessage = GetLocalString(this, "ConfirmDelete", 
					"Are you sure you want to delete the specified events?");
			DeleteButton.Attributes["onclick"] = "return confirm('" + 
				EncodeJavaScriptString(confirmdeletemessage) + "');";			
		}

		public override string GetHighlightedMenuItem()
		{
			return "Management_TransactionLog";
		}

		protected override bool CheckUserPrivileges(Orciid.Core.User user)
		{
			return (user != null && user.Administrator);
		}
 
		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.ShowButton.Click += new System.EventHandler(this.ShowButton_Click);
			this.DeleteButton.Click += new System.EventHandler(this.DeleteButton_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void ShowButton_Click(object sender, System.EventArgs e)
		{
			string title = EventTypeDropDownList.SelectedValue;
			if (title == GetLocalString(this, "ALL", "[ALL]"))
				title = null;
			DateTime from;
			DateTime until;
			try
			{
				from = DateTime.Parse(DateRangeFromTextBox.Text);
			}
			catch
			{
				from = DateTime.MinValue;
			}
			DateRangeFromTextBox.Text = from.ToShortDateString();
			try
			{
				until = DateTime.Parse(DateRangeUntilTextBox.Text);
			}
			catch
			{
				until = DateTime.MaxValue;
			}
			DateRangeUntilTextBox.Text = until.ToShortDateString();
			until += TimeSpan.FromDays(1) - TimeSpan.FromSeconds(1);
			TransactionLogEvent[] events = TransactionLog.Instance.GetEvents(title, from, until);
			EventsDataGrid.DataSource = events;
			EventsDataGrid.DataBind();
		}

		private void DeleteButton_Click(object sender, System.EventArgs e)
		{
			string title = EventTypeDropDownList.SelectedValue;
			if (title == GetLocalString(this, "ALL", "[ALL]"))
				title = null;
			DateTime from;
			DateTime until;
			try
			{
				from = DateTime.Parse(DateRangeFromTextBox.Text);
			}
			catch
			{
				ShowError(GetLocalString(this, "InvalidStartDate", "Invalid start date"));
				return;
			}
			DateRangeFromTextBox.Text = from.ToShortDateString();
			try
			{
				until = DateTime.Parse(DateRangeUntilTextBox.Text);
			}
			catch
			{
				ShowError(GetLocalString(this, "InvalidEndDate", "Invalid end date"));
				return;
			}
			DateRangeUntilTextBox.Text = until.ToShortDateString();
			until += TimeSpan.FromDays(1) - TimeSpan.FromSeconds(1);
			int deleted = TransactionLog.Instance.DeleteEvents(title, from, until);
			ShowInformation(
				String.Format(GetLocalString(this, "DeletionCount", "{0} events deleted"),
				deleted));
			ShowButton_Click(null, null);
		}
	}
}
