using Root.Reports;
using System;
using System.Drawing;

// Creation date: 19.08.2002
// Checked: 12.12.2002
// Author: Otto Mayer (mot@root.ch)
// Version: 1.01

// Report.NET copyright 2002-2004 root-software ag, Brglen Switzerland - Otto Mayer, Stefan Spirig, all rights reserved
// This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation, version 2.1 of the License.
// This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details. You
// should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA www.opensource.org/licenses/lgpl-license.html

namespace ReportSamples {
  /// <summary>Font Test</summary>
  public class FontTest : Report {
    private FontProp fp;
    private FontProp fp_Small;
    private FontProp fp_XSmall;
    private BrushProp bp;
    private Double rX;
    private Double rY;

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Prints the specified character at the current position.</summary>
    /// <param name="iChar">Character code</param>
    protected void PrintCharacter(Int32 iChar) {
      if (rX > 185) {  // new line
        rY += fp.rLineFeedMM;
        rX = 22;
      }
      if (rY > 280) {  // new page
        new Page(this);
        rY = 40;
      }

      Char ch = (Char)iChar;
      String s = ch.ToString();
      Double rWidth = fp.rWidthMM(s);
      Double rHeight = fp.rLineFeedMM * 0.65;
      page_Cur.AddRightMM(rX, rY - 2.5, new RepInt32(fp_Small, (Int32)ch));
      page_Cur.AddMM(rX + 0.1, rY - 2, new RepInt32(fp_XSmall, 10));
      if (iChar < 256) {
        Int32 iOct = (iChar % 8) + 10 * ((iChar / 8) % 8) + 100 * ((iChar / 64) % 8);
        page_Cur.AddRightMM(rX, rY, new RepInt32(fp_Small, iOct, ""));
        page_Cur.AddMM(rX + 0.1, rY + 0.5, new RepInt32(fp_XSmall, 8));
      }
      page_Cur.AddMM(rX + 2, rY, new RepRectMM(bp, rWidth, rHeight));
      page_Cur.AddMM(rX + 2, rY, new RepString(fp, s));
      rX += 15;
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Creates this document</summary>
    protected override void Create() {
      FontDef fd = new FontDef(this, FontDef.StandardFont.Helvetica);
      FontProp fp_Title = new FontPropMM(fd, 12);
      fp_Title.bBold = true;

      fp = new FontPropMM(fd, 6);
      fp_Small = new FontPropMM(fd, 1.4);
      fp_XSmall = new FontPropMM(fd, 0.8);
      bp = new BrushProp(this, Color.FromArgb(200, 200, 200));

      page_Cur = new Page(this);
      page_Cur.AddCB_MM(30, new RepString(fp_Title, "Font Test"));

      rX = 300;
      rY = 40;
      for (Int32 i = 32;  i < 127;  i++) {
        PrintCharacter(i);
      }
      for (Int32 i = 161;  i < 256;  i++) {
        PrintCharacter(i);
      }
      PrintCharacter('');
    }

  }
}
