using System;
//using System.Collections;
 
// Creation date: 11.10.2002
// Checked: xx.05.2002
// Author: Otto Mayer (mot@root.ch)
// Version: 1.01

// Report.NET copyright 2002-2004 root-software ag, Brglen Switzerland - O. Mayer, S. Spirig, R. Gartenmann, all rights reserved
// This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation, version 2.1 of the License.
// This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details. You
// should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA www.opensource.org/licenses/lgpl-license.html

namespace Root.Reports {
  /// <summary>Font Data Class</summary>
  /// <remarks>This is the base class for several font types that are supported by the Report.NET library.</remarks>
  public abstract class FontData {
    /// <summary>Font style</summary>
    public enum Style {
      /// <summary>Standard style</summary>
      Standard,
      /// <summary>Bold style</summary>
      Bold,
      /// <summary>Italic style</summary>
      Italic,
      /// <summary>Bold and italic style</summary>
      BoldItalic
    }

    /// <summary>Font encoding</summary>
    public enum Encoding {
      /// <summary>CP 1250 encoding</summary>
      Cp1250,
      /// <summary>CP 1252 (WIN ANSI) encoding</summary>
      Cp1252,
      /// <summary>CP 1257 encoding</summary>
      Cp1257,
      /// <summary>MAC ROMAN encoding</summary>
      MacRoman
    }

    /// <summary>Encoding for this font</summary>
    protected Encoding encoding;

    /* Creates a new font. This font can be one of the 14 built in types,
     * a Type1 font referred by an AFM file, a TrueType font (simple or collection) or a CJK font from the
     * Adobe Asian Font Pack. TrueType fonts and CJK fonts can have an optional style modifier
     * appended to the name. These modifiers are: Bold, Italic and BoldItalic. An
     * example would be "STSong-Light,Bold". Note that this modifiers do not work if
     * the font is embedded. Fonts in TrueType collections are addressed by index such as "msgothic.ttc,1".
     * This would get the second font (indexes start at 0), in this case "MS PGothic".
     * <P>
     * The fonts may or may not be cached depending on the flag <CODE>cached</CODE>.
     * If the <CODE>byte</CODE> arrays are present the font will be
     * read from them instead of the name. The name is still required to identify
     * the font type.
     * @param name the name of the font or it's location on file
     * @param encoding the encoding to be applied to this font
     * @param embedded true if the font is to be embedded in the PDF
     * @param cached true if the font comes from the cache or is added to
     * the cache if new. false if the font is always created new
     * @param ttfAfm the true type font or the afm in a byte array
     * @param pfb the pfb in a byte array
     * @return returns a new font. This font may come from the cache but only if cached
     * is true, otherwise it will always be created new
     * @throws DocumentException the font is invalid
     * @throws IOException the font file could not be read
     */
    internal FontData(Style style, Encoding encoding, Boolean bEmbedded /*, byte ttfAfm[], byte pfb[]*/) {
      this.encoding = encoding;
      //dsfds
    }

  }
}
