using NUnit.Framework;

namespace DotNetMock.Tests
{
	/// <summary>
	/// Summary description for ExpectationBoolTests.
	/// </summary>
	[TestFixture]
	public class ExpectationBoolTests
	{
		private ExpectationBool _expectationBool = null;

		[SetUp]
		public void Init()
		{
			_expectationBool = new ExpectationBool("ExpectationBool.Tests");
		}

		[TearDown]
		public void Desstroy()
		{
			_expectationBool = null;
		}

		[Test]
		public void SetActual()
		{
			Assert.IsTrue(!_expectationBool.Actual);
			_expectationBool.Actual = true;
			Assert.IsTrue(_expectationBool.Actual);
			_expectationBool.ClearActual();
			Assert.IsTrue(!_expectationBool.Actual);
		}

		[Test]
		public void SetExpected()
		{
			Assert.IsTrue(!_expectationBool.Expected);
			_expectationBool.Expected = true;
			Assert.IsTrue(_expectationBool.Expected);
			_expectationBool.ClearExpected();
			Assert.IsTrue(!_expectationBool.Expected);
		}

		[Test]
		public void HasExpectations()
		{
			Assert.IsTrue(!_expectationBool.Expected);
			_expectationBool.Expected = true;
			Assert.IsTrue(_expectationBool.Expected);
			Assert.IsTrue(_expectationBool.HasExpectations);
			_expectationBool.ClearExpected();
			Assert.IsTrue(!_expectationBool.HasExpectations);
		}

		[Test]
		public void Verify()
		{
			_expectationBool.Actual = true;
			_expectationBool.Expected = false;

			try 
			{
				_expectationBool.Verify();
				Assert.Fail("Should have thrown an exception.");
			}
			catch
			{
			}

			_expectationBool.Expected = true;
			_expectationBool.Verify();
		}
		[Test]
		public void FailureMode()
		{
			_expectationBool.Expected = true;

			Assert.IsTrue(_expectationBool.HasExpectations);
			Assert.IsTrue(!(_expectationBool.ShouldCheckImmediate));
			_expectationBool.VerifyImmediate = true;
			Assert.IsTrue(_expectationBool.ShouldCheckImmediate);
			
		}
		[Test]
		public void ClearActual()
		{
			Assert.IsTrue(!_expectationBool.Actual);
			_expectationBool.Actual = true;
			Assert.IsTrue(_expectationBool.Actual);
			_expectationBool.ClearActual();
			Assert.IsTrue(!_expectationBool.Actual);
		}

		[Test]
		public void ClearExpected()
		{
			Assert.IsTrue(!_expectationBool.Expected);
			_expectationBool.Expected = true;
			Assert.IsTrue(_expectationBool.Expected);
			_expectationBool.ClearExpected();
			Assert.IsTrue(!_expectationBool.Expected);
		}
		[Test]
		public void ShouldCheckImmediate()
		{
			_expectationBool.Expected = false;
			_expectationBool.VerifyImmediate = true;
			_expectationBool.Actual = false;
		}
	}
}
