using System;
using DotNetMock;

namespace DotNetMock.Examples.CustomExpectation
{
	public class ExpectationPerson : AbstractStaticExpectation
	{
		private Person _actualPerson = null;
		private Person _expectedPerson = null;

		public ExpectationPerson( string name ) : base( name ) {
		}
		
		public Person Expected
		{
			get { return _expectedPerson; }
			set { 
				_expectedPerson = value;
				HasExpectations = true;
			}
		}
		public Person Actual
		{
			get { return _actualPerson; }
			set { _actualPerson = value; }
		}
		public override void ClearActual()
		{
			_actualPerson = null;
		}
		public override void ClearExpected()
		{
			_expectedPerson = null; 
		}

		public override void Verify()
		{
			Assertion.AssertEquals( "People do not match. Expected Name: " + _expectedPerson.Name + " , Actual Name: " + _actualPerson.Name , _expectedPerson.Name, _actualPerson.Name );
			Assertion.AssertEquals( "People do not match. Expected Age: " + _expectedPerson.Age + " , Actual Age: " + _actualPerson.Age , _expectedPerson.Age, _actualPerson.Age );
		}
	}
}
