namespace DotNetMock.Examples.Dynamic
{

	public class Weather 
	{
		private IWeatherRandom random;
		private bool isRaining = false;
		private double temperature = 0.0;
			
		public Weather( IWeatherRandom random ) 
		{
			this.random = random;
		}
		
		public bool IsRaining
		{
			get { return isRaining; }
		}
		
		public double Temperature
		{
			get { return temperature; }
		}
		
		public void Randomize() 
		{
			temperature = random.NextTemperature();
			isRaining = random.NextIsRaining();
			if( isRaining ) temperature *= 0.5;
		}
		
	}
}
