using System;

namespace DotNetMock.Examples.MailingList
{
	/// <summary>
	/// Summary description for MockListAction.
	/// </summary>
	public class MockListAction : MockObject, IListAction
	{
		private ExpectationCounter _memberCount = new ExpectationCounter("MockListAction.Count");
		private ExpectationArrayList _members = new ExpectationArrayList("MockListAction.Members");

		private MailingListException _exception = null;

		public MockListAction()
		{
			
		}

		#region Implementation of IListAction
		public void ApplyTo(string email, string name)
		{
			_memberCount.Inc();
			if (_exception != null)
				throw _exception;
			_members.AddActualMany(new object[] {email, name});
		}
		#endregion
		public void AddExpectedMember(string email, string name) 
		{
			_members.AddExpectedMany(new object[] {email, name});
		}
		public void SetExpectedMemberCount(int count)
		{
			_memberCount.Expected = count;
		}
		public void SetExpectNoMembers() 
		{
			_memberCount.ExpectNothing();
			_members.ExpectNothing();
		}
		public void SetupMemberException(MailingListException exception)
		{
			_exception = exception;
		}
	}
}
