using NUnit.Framework;

namespace DotNetMock.Tests 
{	
	[TestFixture]
	public class ExpectationCounterTests {
		
		private ExpectationCounter _counter;
		
		[SetUp]
		public void SetUp()
		{
			_counter = new ExpectationCounter("ExpectationCounter");
		}
		
		[TearDown]
		public void TearDown()
		{
			_counter = null;
		}
		
		[Test]
		public void ExpectNothing() {
			_counter.ExpectNothing();
			
			Assert.IsTrue( _counter.HasExpectations, "Has expectation");
			_counter.Verify();
		}
		
		[Test]
    	[ExpectedException(typeof(AssertionException))]
    	public void ExpectNothingFailure()
    	{
			_counter.ExpectNothing();
			_counter.VerifyImmediate = true;
			
			Assert.IsTrue( _counter.HasExpectations, "Has expectation");
			_counter.Inc();
		}
		    	
		[Test]
		[ExpectedException(typeof(AssertionException))]
		public void FailImmediately()
		{
			_counter.Expected = 1;
			_counter.VerifyImmediate = true;
			_counter.Inc();
			_counter.Inc();
		}
		
		[Test]
		[ExpectedException(typeof(AssertionException))]
		public void FailOnVerify()
		{
			_counter.Strict = true;
			_counter.Expected = 1;
			_counter.Inc();
			_counter.Inc();
			_counter.Verify();
		}
		
		[Test]
		[ExpectedException(typeof(AssertionException))]
		public void NotEnoughCalls()
		{
			_counter.Expected = 1;
			_counter.Verify();
		}
		[Test]
		[ExpectedException(typeof(AssertionException))]
		public void TooManyCalls() 
		{
			_counter.Strict = true;
			_counter.Expected = 1;
			_counter.Inc();
			_counter.Inc();
			_counter.Verify();
		}
		[Test]
		public void NonStrictCalls() 
		{
			_counter.Strict = false;
			_counter.Expected = 1;
			_counter.Inc();
			_counter.Inc();
			_counter.Verify();
		}
		[Test]
		public void NonStrictCallsNoExpectations() 
		{
			_counter.Strict = false;
			_counter.Inc();
			_counter.Inc();
			_counter.Verify();
		}
		[Test]
		public void FlushActual()
		{
			_counter.Inc();
			_counter.ClearActual();
			_counter.Expected = 1;
			_counter.Inc();
			_counter.Verify();
		}
		
		[Test]
		public void HasNoExpectations()
		{
			_counter.Inc();
			Assert.IsTrue( !_counter.HasExpectations, "Should have no expectations");
			_counter.Verify();
		}
		
		[Test]
		public void Success()
		{
			_counter.Expected = 1;
			_counter.Inc();
			_counter.Verify();
		}
	}
}
