package com.thoughtworks.selenium.corebased;
import com.thoughtworks.selenium.*;
/**
 * @author XlateHtmlSeleneseToJava
 * Generated from E:\buildroot\Dev\selenium-rc_svn\trunk\rc\clients\java\target\selenium-server\tests/TestClick.html.
 */
public class TestClick extends SeleneseTestCase
{
   public void testClick() throws Throwable {
		selenium.setContext("Test Click", "info");

/* Test Click */
		// open|../tests/html/test_click_page1.html|
		selenium.open("../tests/html/test_click_page1.html");

		/* Click a regular link */
		// verifyText|link|Click here for next page
		verifyEquals("Click here for next page", selenium.getText("link"));
		// clickAndWait|link|
		selenium.click("link");
		// verifyTitle|Click Page Target|
		verifyEquals("Click Page Target", selenium.getTitle());
		// clickAndWait|previousPage|
		selenium.click("previousPage");
		// verifyTitle|Click Page 1|
		verifyEquals("Click Page 1", selenium.getTitle());

		/* Click a link with an enclosed image */
		// clickAndWait|linkWithEnclosedImage|
		selenium.click("linkWithEnclosedImage");
		// verifyTitle|Click Page Target|
		verifyEquals("Click Page Target", selenium.getTitle());
		// clickAndWait|previousPage|
		selenium.click("previousPage");

		/* Click an image enclosed by a link */
		// clickAndWait|enclosedImage|
		selenium.click("enclosedImage");
		// verifyTitle|Click Page Target|
		verifyEquals("Click Page Target", selenium.getTitle());
		// clickAndWait|previousPage|
		selenium.click("previousPage");

		/* Click a link with an href anchor target within this page */
		// click|linkToAnchorOnThisPage|
		selenium.click("linkToAnchorOnThisPage");
		// verifyTitle|Click Page 1|
		verifyEquals("Click Page 1", selenium.getTitle());

		/* Click a link where onclick returns false */
		// click|linkWithOnclickReturnsFalse|
		selenium.click("linkWithOnclickReturnsFalse");

		/* Need a pause to give the page a chance to reload (so this test can fail) */
		// pause|300
		pause(300);
		// verifyTitle|Click Page 1|
		verifyEquals("Click Page 1", selenium.getTitle());

		/* TODO Click a link with a target attribute */

		checkForVerificationErrors();
	}
}
