package com.thoughtworks.selenium.corebased;
import com.thoughtworks.selenium.*;
/**
 * @author XlateHtmlSeleneseToJava
 * Generated from E:\buildroot\Dev\selenium-rc_svn\trunk\rc\clients\java\target\selenium-server\tests/TestMultiSelect.html.
 */
public class TestMultiSelect extends SeleneseTestCase
{
   public void testMultiSelect() throws Throwable {
		selenium.setContext("Test Select", "info");

/* Test Multiple Select */
		// open|../tests/html/test_multiselect.html|
		selenium.open("../tests/html/test_multiselect.html");
		String[] tmp2 = {"Second Option"};
		// assertSelectedLabels|theSelect|Second Option
		assertEquals(tmp2, selenium.getSelectedLabels("theSelect"));

		/* Select a single element (replaces existing selection) */
		// select|theSelect|index=4
		selenium.select("theSelect", "index=4");
		String[] tmp3 = {"Fifth Option"};
		// verifySelectedLabels|theSelect|Fifth Option
		verifyEquals(tmp3, selenium.getSelectedLabels("theSelect"));

		/* Select additional elements */
		// addSelection|theSelect|Third Option
		selenium.addSelection("theSelect", "Third Option");
		// addSelection|theSelect|value=
		selenium.addSelection("theSelect", "value=");
		String[] tmp4 = {"Third Option", "Fifth Option", "Empty Value Option"};
		// verifySelectedLabels|theSelect|Third Option,Fifth Option,Empty Value Option
		verifyEquals(tmp4, selenium.getSelectedLabels("theSelect"));
		// removeSelection|theSelect|id=o7
		selenium.removeSelection("theSelect", "id=o7");
		String[] tmp5 = {"Third Option", "Fifth Option"};
		// verifySelectedLabels|theSelect|Third Option,Fifth Option
		verifyEquals(tmp5, selenium.getSelectedLabels("theSelect"));
		// removeSelection|theSelect|label=Fifth Option
		selenium.removeSelection("theSelect", "label=Fifth Option");

		boolean sawThrow17 = false;
		try {
			// originally verifySelected|theSelect|Third Option
				assertEquals("Third Option", selenium.getSelectedLabel("theSelect"));
		}
		catch (Throwable e) {
			sawThrow17 = true;
		}
		verifyFalse(sawThrow17);
		
		// addSelection|theSelect|
		selenium.addSelection("theSelect", "");
		String[] tmp6 = {"Third Option", ""};
		// verifySelectedLabels|theSelect|Third Option,
		verifyEquals(tmp6, selenium.getSelectedLabels("theSelect"));
		// removeSelection|theSelect|
		selenium.removeSelection("theSelect", "");
		// removeSelection|theSelect|Third Option
		selenium.removeSelection("theSelect", "Third Option");

		boolean sawThrow22 = false;
		try {
					// assertSelected|theSelect|
		fail("No option selected");
		}
		catch (Throwable e) {
			sawThrow22 = true;
		}
		verifyTrue(sawThrow22);
		

		boolean sawThrow24 = false;
		try {
					String[] tmp7 = {""};
		// assertSelectedLabels|theSelect|
		assertEquals(tmp7, selenium.getSelectedLabels("theSelect"));
		}
		catch (Throwable e) {
			sawThrow24 = true;
		}
		verifyTrue(sawThrow24);
		

		checkForVerificationErrors();
	}
}
