/*
 * Copyright 2006 ThoughtWorks, Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

// This file has been automatically generated via XSL
using System;
namespace Selenium
{
	/// <summary>Defines an object that runs Selenium commands.
	/// 
	/// <h3><a name="locators"></a>Element Locators</h3><p>
	/// Element Locators tell Selenium which HTML element a command refers to.
	/// The format of a locator is:</p><blockquote><em>locatorType</em><strong>=</strong><em>argument</em></blockquote><p>
	/// We support the following strategies for locating elements:
	/// </p><blockquote><dl><dt><strong>identifier</strong>=<em>id</em></dt><dd>Select the element with the specified @id attribute. If no match is
	/// found, select the first element whose @name attribute is <em>id</em>.
	/// (This is normally the default; see below.)</dd><dt><strong>id</strong>=<em>id</em></dt><dd>Select the element with the specified @id attribute.</dd><dt><strong>name</strong>=<em>name</em></dt><dd>Select the first element with the specified @name attribute.</dd><dd><ul class="first last simple"><li>username</li><li>name=username</li></ul></dd><dd>The name may optionally be followed by one or more <em>element-filters</em>, separated from the name by whitespace.  If the <em>filterType</em> is not specified, <strong>value</strong> is assumed.</dd><dd><ul class="first last simple"><li>name=flavour value=chocolate</li></ul></dd><dt><strong>dom</strong>=<em>javascriptExpression</em></dt><dd><dd>Find an element using JavaScript traversal of the HTML Document Object
	/// Model. DOM locators <em>must</em> begin with "document.".
	/// <ul class="first last simple"><li>dom=document.forms['myForm'].myDropdown</li><li>dom=document.images[56]</li></ul></dd></dd><dt><strong>xpath</strong>=<em>xpathExpression</em></dt><dd>Locate an element using an XPath expression.
	/// <ul class="first last simple"><li>xpath=//img[@alt='The image alt text']</li><li>xpath=//table[@id='table1']//tr[4]/td[2]</li></ul></dd><dt><strong>link</strong>=<em>textPattern</em></dt><dd>Select the link (anchor) element which contains text matching the
	/// specified <em>pattern</em>.
	/// <ul class="first last simple"><li>link=The link text</li></ul></dd></dl></blockquote><p>
	/// Without an explicit locator prefix, Selenium uses the following default
	/// strategies:
	/// </p><ul class="simple"><li><strong>dom</strong>, for locators starting with "document."</li><li><strong>xpath</strong>, for locators starting with "//"</li><li><strong>identifier</strong>, otherwise</li></ul><h3><a name="element-filters">Element Filters</a></h3><blockquote><p>Element filters can be used with a locator to refine a list of candidate elements.  They are currently used only in the 'name' element-locator.</p><p>Filters look much like locators, ie.</p><blockquote><em>filterType</em><strong>=</strong><em>argument</em></blockquote><p>Supported element-filters are:</p><p><strong>value=</strong><em>valuePattern</em></p><blockquote>
	/// Matches elements based on their values.  This is particularly useful for refining a list of similarly-named toggle-buttons.</blockquote><p><strong>index=</strong><em>index</em></p><blockquote>
	/// Selects a single element based on its position in the list (offset from zero).</blockquote></blockquote><h3><a name="patterns"></a>String-match Patterns</h3><p>
	/// Various Pattern syntaxes are available for matching string values:
	/// </p><blockquote><dl><dt><strong>glob:</strong><em>pattern</em></dt><dd>Match a string against a "glob" (aka "wildmat") pattern. "Glob" is a
	/// kind of limited regular-expression syntax typically used in command-line
	/// shells. In a glob pattern, "*" represents any sequence of characters, and "?"
	/// represents any single character. Glob patterns match against the entire
	/// string.</dd><dt><strong>regexp:</strong><em>regexp</em></dt><dd>Match a string using a regular-expression. The full power of JavaScript
	/// regular-expressions is available.</dd><dt><strong>exact:</strong><em>string</em></dt><dd>Match a string exactly, verbatim, without any of that fancy wildcard
	/// stuff.</dd></dl></blockquote><p>
	/// If no pattern prefix is specified, Selenium assumes that it's a "glob"
	/// pattern.
	/// </p>
	/// </summary>
	// This file has been automatically generated using XSL
	// This part of the file is hard-coded in the XSL
	public class DefaultSelenium : ISelenium
	{
	
		protected ICommandProcessor commandProcessor;
		/// <summary>
		/// Uses a CommandBridgeClient, specifying a server host/port, a command to launch the browser, and a starting URL for the browser.
	    /// 
	    /// <p><i>browserString</i> may be any one of the following:</p>
	    /// <ul>
	    /// <li><code>*firefox [absolute path]</code> - Automatically launch a new Firefox process using a custom Firefox profile.
	    /// This profile will be automatically configured to use the Selenium Server as a proxy and to have all annoying prompts
	    /// ("save your password?" "forms are insecure" "make Firefox your default browser?" disabled.  You may optionally specify
	    /// an absolute path to your firefox executable, or just say "*firefox".  If no absolute path is specified, we'll look for
	    /// firefox.exe in a default location (normally c:\program files\mozilla firefox\firefox.exe), which you can override by
	    /// setting the Java system property <code>firefoxDefaultPath</code> to the correct path to Firefox.</li>
	    /// <li><code>*iexplore [absolute path]</code> - Automatically launch a new Internet Explorer process using custom Windows registry settings.
	    /// This process will be automatically configured to use the Selenium Server as a proxy and to have all annoying prompts
	    /// ("save your password?" "forms are insecure" "make Firefox your default browser?" disabled.  You may optionally specify
	    /// an absolute path to your iexplore executable, or just say "*iexplore".  If no absolute path is specified, we'll look for
	    /// iexplore.exe in a default location (normally c:\program files\internet explorer\iexplore.exe), which you can override by
	    /// setting the Java system property <code>iexploreDefaultPath</code> to the correct path to Internet Explorer.</li>
	    /// <li><code>/path/to/my/browser [other arguments]</code> - You may also simply specify the absolute path to your browser
	    /// executable, or use a relative path to your executable (which we'll try to find on your path).  <b>Warning:</b> If you
	    /// specify your own custom browser, it's up to you to configure it correctly.  At a minimum, you'll need to configure your
	    /// browser to use the Selenium Server as a proxy, and disable all browser-specific prompting.</li>
	    /// </ul>
	    /// </summary>
	    /// 
	    /// <param name="serverHost">the host name on which the Selenium Server resides</param>
	    /// <param name="serverPort">the port on which the Selenium Server is listening</param>
	    /// <param name="browserString">the command string used to launch the browser, e.g. "*firefox", "*iexplore" or "c:\\program files\\internet explorer\\iexplore.exe"</param>
	    /// <param name="browserURL">the starting URL including just a domain name.  We'll start the browser pointing at the Selenium resources on this URL,
	    /// e.g. "http://www.google.com" would send the browser to "http://www.google.com/selenium-server/SeleneseRunner.html"</param>
	    public DefaultSelenium(String serverHost, int serverPort, String browserString, String browserURL)
	    {
	        this.commandProcessor = new HttpCommandProcessor(serverHost, serverPort, browserString, browserURL);
	    }
	    
	    /// <summary>
	    /// Uses an arbitrary CommandProcessor
	    /// </summary>
	    public DefaultSelenium(ICommandProcessor processor)
	    {
	        this.commandProcessor = processor;
	    }
	    
	    /// <summary>
	    /// The command processor that handles all of our Selenium commands
	    /// </summary>
	    public ICommandProcessor Processor
		{
	        get { return this.commandProcessor; }
		}
		
		/// <summary>
		/// Starts a new Selenium testing session
		/// </summary>
		public void Start()
		{
			commandProcessor.Start();
		}
		
		/// <summary>
		/// Ends the current Selenium testing session (normally killing the browser)
		/// </summary>
		public void Stop()
		{
			commandProcessor.Stop();
		}
	    
	    // From here on, everything in this file has been auto-generated
	    
		/// <summary>Clicks on a link, button, checkbox or radio button. If the click action
		/// causes a new page to load (like a link usually does), call
		/// waitForPageToLoad.
		/// </summary>
		/// <param name="locator">an element locator</param>
		public void Click(String locator)
		{
			commandProcessor.DoCommand("click", new String[] {locator,});
		}


		/// <summary>Explicitly simulate an event, to trigger the corresponding "on<em>event</em>"
		/// handler.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		/// <param name="eventName">the event name, e.g. "focus" or "blur"</param>
		public void FireEvent(String locator,String eventName)
		{
			commandProcessor.DoCommand("fireEvent", new String[] {locator,eventName,});
		}


		/// <summary>Simulates a user pressing and releasing a key.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		/// <param name="keycode">the numeric keycode of the key to be pressed, normally the
		///             ASCII value of that key.</param>
		public void KeyPress(String locator,String keycode)
		{
			commandProcessor.DoCommand("keyPress", new String[] {locator,keycode,});
		}


		/// <summary>Simulates a user pressing a key (without releasing it yet).
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		/// <param name="keycode">the numeric keycode of the key to be pressed, normally the
		///             ASCII value of that key.</param>
		public void KeyDown(String locator,String keycode)
		{
			commandProcessor.DoCommand("keyDown", new String[] {locator,keycode,});
		}


		/// <summary>Simulates a user releasing a key.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		/// <param name="keycode">the numeric keycode of the key to be released, normally the
		///             ASCII value of that key.</param>
		public void KeyUp(String locator,String keycode)
		{
			commandProcessor.DoCommand("keyUp", new String[] {locator,keycode,});
		}


		/// <summary>Simulates a user hovering a mouse over the specified element.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		public void MouseOver(String locator)
		{
			commandProcessor.DoCommand("mouseOver", new String[] {locator,});
		}


		/// <summary>Simulates a user pressing the mouse button (without releasing it yet) on
		/// the specified element.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		public void MouseDown(String locator)
		{
			commandProcessor.DoCommand("mouseDown", new String[] {locator,});
		}


		/// <summary>Sets the value of an input field, as though you typed it in.
		/// 
		/// <p>Can also be used to set the value of combo boxes, check boxes, etc. In these cases,
		/// value should be the value of the option selected, not the visible text.</p>
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		/// <param name="value">the value to type</param>
		public void Type(String locator,String value)
		{
			commandProcessor.DoCommand("type", new String[] {locator,value,});
		}


		/// <summary>Check a toggle-button (checkbox/radio)
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		public void Check(String locator)
		{
			commandProcessor.DoCommand("check", new String[] {locator,});
		}


		/// <summary>Uncheck a toggle-button (checkbox/radio)
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		public void Uncheck(String locator)
		{
			commandProcessor.DoCommand("uncheck", new String[] {locator,});
		}


		/// <summary>Select an option from a drop-down using an option locator.
		/// 
		/// <p>
		/// Option locators provide different ways of specifying options of an HTML
		/// Select element (e.g. for selecting a specific option, or for asserting
		/// that the selected option satisfies a specification). There are several
		/// forms of Select Option Locator.
		/// </p><dl><dt><strong>label</strong>=<em>labelPattern</em></dt><dd>matches options based on their labels, i.e. the visible text. (This
		/// is the default.)
		/// <ul class="first last simple"><li>label=regexp:^[Oo]ther</li></ul></dd><dt><strong>value</strong>=<em>valuePattern</em></dt><dd>matches options based on their values.
		/// <ul class="first last simple"><li>value=other</li></ul></dd><dt><strong>id</strong>=<em>id</em></dt><dd>matches options based on their ids.
		/// <ul class="first last simple"><li>id=option1</li></ul></dd><dt><strong>index</strong>=<em>index</em></dt><dd>matches an option based on its index (offset from zero).
		/// <ul class="first last simple"><li>index=2</li></ul></dd></dl><p>
		/// If no option locator prefix is provided, the default behaviour is to match on <strong>label</strong>.
		/// </p>
		/// </summary>
		/// <param name="selectLocator">an <a href="#locators">element locator</a> identifying a drop-down menu</param>
		/// <param name="optionLocator">an option locator (a label by default)</param>
		public void Select(String selectLocator,String optionLocator)
		{
			commandProcessor.DoCommand("select", new String[] {selectLocator,optionLocator,});
		}


		/// <summary>Add a selection to the set of selected options in a multi-select element using an option locator.
		/// 
		/// @see #doSelect for details of option locators
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a> identifying a multi-select box</param>
		/// <param name="optionLocator">an option locator (a label by default)</param>
		public void AddSelection(String locator,String optionLocator)
		{
			commandProcessor.DoCommand("addSelection", new String[] {locator,optionLocator,});
		}


		/// <summary>Remove a selection from the set of selected options in a multi-select element using an option locator.
		/// 
		/// @see #doSelect for details of option locators
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a> identifying a multi-select box</param>
		/// <param name="optionLocator">an option locator (a label by default)</param>
		public void RemoveSelection(String locator,String optionLocator)
		{
			commandProcessor.DoCommand("removeSelection", new String[] {locator,optionLocator,});
		}


		/// <summary>Submit the specified form. This is particularly useful for forms without
		/// submit buttons, e.g. single-input "Search" forms.
		/// </summary>
		/// <param name="formLocator">an <a href="#locators">element locator</a> for the form you want to submit</param>
		public void Submit(String formLocator)
		{
			commandProcessor.DoCommand("submit", new String[] {formLocator,});
		}


		/// <summary>Opens an URL in the test frame. This accepts both relative and absolute
		/// URLs.
		/// 
		/// The "open" command waits for the page to load before proceeding,
		/// ie. the "AndWait" suffix is implicit.
		/// 
		/// <em>Note</em>: The URL must be on the same domain as the runner HTML
		/// due to security restrictions in the browser (Same Origin Policy). If you
		/// need to open an URL on another domain, use the Selenium Server to start a
		/// new browser session on that domain.
		/// </summary>
		/// <param name="url">the URL to open; may be relative or absolute</param>
		public void Open(String url)
		{
			commandProcessor.DoCommand("open", new String[] {url,});
		}


		/// <summary>Selects a popup window; once a popup window has been selected, all
		/// commands go to that window. To select the main window again, use "null"
		/// as the target.
		/// </summary>
		/// <param name="windowID">the JavaScript window ID of the window to select</param>
		public void SelectWindow(String windowID)
		{
			commandProcessor.DoCommand("selectWindow", new String[] {windowID,});
		}


		/// <summary>Waits for a popup window to appear and load up.
		/// </summary>
		/// <param name="windowID">the JavaScript window ID of the window that will appear</param>
		/// <param name="timeout">a timeout in milliseconds, after which the action will return with an error</param>
		public void WaitForPopUp(String windowID,String timeout)
		{
			commandProcessor.DoCommand("waitForPopUp", new String[] {windowID,timeout,});
		}


		/// <summary>By default, Selenium's overridden window.confirm() function will
		/// return true, as if the user had manually clicked OK.  After running
		/// this command, the next call to confirm() will return false, as if
		/// the user had clicked Cancel.
		/// </summary>
		public void ChooseCancelOnNextConfirmation()
		{
			commandProcessor.DoCommand("chooseCancelOnNextConfirmation", new String[] {});
		}


		/// <summary>Instructs Selenium to return the specified answer string in response to
		/// the next JavaScript prompt [window.prompt()].
		/// </summary>
		/// <param name="answer">the answer to give in response to the prompt pop-up</param>
		public void AnswerOnNextPrompt(String answer)
		{
			commandProcessor.DoCommand("answerOnNextPrompt", new String[] {answer,});
		}


		/// <summary>Simulates the user clicking the "back" button on their browser.
		/// </summary>
		public void GoBack()
		{
			commandProcessor.DoCommand("goBack", new String[] {});
		}


		/// <summary>Simulates the user clicking the "Refresh" button on their browser.
		/// </summary>
		public void Refresh()
		{
			commandProcessor.DoCommand("refresh", new String[] {});
		}


		/// <summary>Simulates the user clicking the "close" button in the titlebar of a popup
		/// window or tab.
		/// </summary>
		public void Close()
		{
			commandProcessor.DoCommand("close", new String[] {});
		}


		/// <summary>Has an alert occurred?
		/// 
		/// <p>
		/// This function never throws an exception
		/// </p>
		/// </summary>
		/// <returns>true if there is an alert</returns>
		public bool IsAlertPresent()
		{
			return commandProcessor.GetBoolean("isAlertPresent", new String[] {});
		}


		/// <summary>Has a prompt occurred?
		/// 
		/// <p>
		/// This function never throws an exception
		/// </p>
		/// </summary>
		/// <returns>true if there is a pending prompt</returns>
		public bool IsPromptPresent()
		{
			return commandProcessor.GetBoolean("isPromptPresent", new String[] {});
		}


		/// <summary>Has confirm() been called?
		/// 
		/// <p>
		/// This function never throws an exception
		/// </p>
		/// </summary>
		/// <returns>true if there is a pending confirmation</returns>
		public bool IsConfirmationPresent()
		{
			return commandProcessor.GetBoolean("isConfirmationPresent", new String[] {});
		}


		/// <summary>Retrieves the message of a JavaScript alert generated during the previous action, or fail if there were no alerts.
		/// 
		/// <p>Getting an alert has the same effect as manually clicking OK. If an
		/// alert is generated but you do not get/verify it, the next Selenium action
		/// will fail.</p><p>NOTE: under Selenium, JavaScript alerts will NOT pop up a visible alert
		/// dialog.</p><p>NOTE: Selenium does NOT support JavaScript alerts that are generated in a
		/// page's onload() event handler. In this case a visible dialog WILL be
		/// generated and Selenium will hang until someone manually clicks OK.</p>
		/// </summary>
		/// <returns>The message of the most recent JavaScript alert</returns>
		public String GetAlert()
		{
			return commandProcessor.GetString("getAlert", new String[] {});
		}


		/// <summary>Retrieves the message of a JavaScript confirmation dialog generated during
		/// the previous action.
		/// 
		/// <p>
		/// By default, the confirm function will return true, having the same effect
		/// as manually clicking OK. This can be changed by prior execution of the
		/// chooseCancelOnNextConfirmation command. If an confirmation is generated
		/// but you do not get/verify it, the next Selenium action will fail.
		/// </p><p>
		/// NOTE: under Selenium, JavaScript confirmations will NOT pop up a visible
		/// dialog.
		/// </p><p>
		/// NOTE: Selenium does NOT support JavaScript confirmations that are
		/// generated in a page's onload() event handler. In this case a visible
		/// dialog WILL be generated and Selenium will hang until you manually click
		/// OK.
		/// </p>
		/// </summary>
		/// <returns>the message of the most recent JavaScript confirmation dialog</returns>
		public String GetConfirmation()
		{
			return commandProcessor.GetString("getConfirmation", new String[] {});
		}


		/// <summary>Retrieves the message of a JavaScript question prompt dialog generated during
		/// the previous action.
		/// 
		/// <p>Successful handling of the prompt requires prior execution of the
		/// answerOnNextPrompt command. If a prompt is generated but you
		/// do not get/verify it, the next Selenium action will fail.</p><p>NOTE: under Selenium, JavaScript prompts will NOT pop up a visible
		/// dialog.</p><p>NOTE: Selenium does NOT support JavaScript prompts that are generated in a
		/// page's onload() event handler. In this case a visible dialog WILL be
		/// generated and Selenium will hang until someone manually clicks OK.</p>
		/// </summary>
		/// <returns>the message of the most recent JavaScript question prompt</returns>
		public String GetPrompt()
		{
			return commandProcessor.GetString("getPrompt", new String[] {});
		}


		/// <summary>Gets the absolute URL of the current page.
		/// </summary>
		/// <returns>the absolute URL of the current page</returns>
		public String GetLocation()
		{
			return commandProcessor.GetString("getLocation", new String[] {});
		}


		/// <summary>Gets the title of the current page.
		/// </summary>
		/// <returns>the title of the current page</returns>
		public String GetTitle()
		{
			return commandProcessor.GetString("getTitle", new String[] {});
		}


		/// <summary>Gets the entire text of the page.
		/// </summary>
		/// <returns>the entire text of the page</returns>
		public String GetBodyText()
		{
			return commandProcessor.GetString("getBodyText", new String[] {});
		}


		/// <summary>Gets the (whitespace-trimmed) value of an input field (or anything else with a value parameter).
		/// For checkbox/radio elements, the value will be "on" or "off" depending on
		/// whether the element is checked or not.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		/// <returns>the element value, or "on/off" for checkbox/radio elements</returns>
		public String GetValue(String locator)
		{
			return commandProcessor.GetString("getValue", new String[] {locator,});
		}


		/// <summary>Gets the text of an element. This works for any element that contains
		/// text. This command uses either the textContent (Mozilla-like browsers) or
		/// the innerText (IE-like browsers) of the element, which is the rendered
		/// text shown to the user.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		/// <returns>the text of the element</returns>
		public String GetText(String locator)
		{
			return commandProcessor.GetString("getText", new String[] {locator,});
		}


		/// <summary>Gets the result of evaluating the specified JavaScript snippet.  The snippet may 
		/// have multiple lines, but only the result of the last line will be returned.
		/// 
		/// <p>Note that, by default, the snippet will run in the context of the "selenium"
		/// object itself, so <code>this</code> will refer to the Selenium object, and <code>window</code> will
		/// refer to the top-level runner test window, not the window of your application.</p><p>If you need a reference to the window of your application, you can refer
		/// to <code>this.browserbot.getCurrentWindow()</code> and if you need to use
		/// a locator to refer to a single element in your application page, you can
		/// use <code>this.page().findElement("foo")</code> where "foo" is your locator.</p>
		/// </summary>
		/// <param name="script">the JavaScript snippet to run</param>
		/// <returns>the results of evaluating the snippet</returns>
		public String GetEval(String script)
		{
			return commandProcessor.GetString("getEval", new String[] {script,});
		}


		/// <summary>Gets whether a toggle-button (checkbox/radio) is checked.  Fails if the specified element doesn't exist or isn't a toggle-button.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a> pointing to a checkbox or radio button</param>
		/// <returns>true if the checkbox is checked, false otherwise</returns>
		public bool IsChecked(String locator)
		{
			return commandProcessor.GetBoolean("isChecked", new String[] {locator,});
		}


		/// <summary>Gets the text from a cell of a table. The cellAddress syntax
		/// tableLocator.row.column, where row and column start at 0.
		/// </summary>
		/// <param name="tableCellAddress">a cell address, e.g. "foo.1.4"</param>
		/// <returns>the text from the specified cell</returns>
		public String GetTable(String tableCellAddress)
		{
			return commandProcessor.GetString("getTable", new String[] {tableCellAddress,});
		}


		/// <summary>Gets all option labels (visible text) for selected options in the specified select or multi-select element.
		/// </summary>
		/// <param name="selectLocator">an <a href="#locators">element locator</a> identifying a drop-down menu</param>
		/// <returns>an array of all selected option labels in the specified select drop-down</returns>
		public String[] GetSelectedLabels(String selectLocator)
		{
			return commandProcessor.GetStringArray("getSelectedLabels", new String[] {selectLocator,});
		}


		/// <summary>Gets option label (visible text) for selected option in the specified select element.
		/// </summary>
		/// <param name="selectLocator">an <a href="#locators">element locator</a> identifying a drop-down menu</param>
		/// <returns>the selected option label in the specified select drop-down</returns>
		public String GetSelectedLabel(String selectLocator)
		{
			return commandProcessor.GetString("getSelectedLabel", new String[] {selectLocator,});
		}


		/// <summary>Gets all option values (value attributes) for selected options in the specified select or multi-select element.
		/// </summary>
		/// <param name="selectLocator">an <a href="#locators">element locator</a> identifying a drop-down menu</param>
		/// <returns>an array of all selected option values in the specified select drop-down</returns>
		public String[] GetSelectedValues(String selectLocator)
		{
			return commandProcessor.GetStringArray("getSelectedValues", new String[] {selectLocator,});
		}


		/// <summary>Gets option value (value attribute) for selected option in the specified select element.
		/// </summary>
		/// <param name="selectLocator">an <a href="#locators">element locator</a> identifying a drop-down menu</param>
		/// <returns>the selected option value in the specified select drop-down</returns>
		public String GetSelectedValue(String selectLocator)
		{
			return commandProcessor.GetString("getSelectedValue", new String[] {selectLocator,});
		}


		/// <summary>Gets all option indexes (option number, starting at 0) for selected options in the specified select or multi-select element.
		/// </summary>
		/// <param name="selectLocator">an <a href="#locators">element locator</a> identifying a drop-down menu</param>
		/// <returns>an array of all selected option indexes in the specified select drop-down</returns>
		public String[] GetSelectedIndexes(String selectLocator)
		{
			return commandProcessor.GetStringArray("getSelectedIndexes", new String[] {selectLocator,});
		}


		/// <summary>Gets option index (option number, starting at 0) for selected option in the specified select element.
		/// </summary>
		/// <param name="selectLocator">an <a href="#locators">element locator</a> identifying a drop-down menu</param>
		/// <returns>the selected option index in the specified select drop-down</returns>
		public String GetSelectedIndex(String selectLocator)
		{
			return commandProcessor.GetString("getSelectedIndex", new String[] {selectLocator,});
		}


		/// <summary>Gets all option element IDs for selected options in the specified select or multi-select element.
		/// </summary>
		/// <param name="selectLocator">an <a href="#locators">element locator</a> identifying a drop-down menu</param>
		/// <returns>an array of all selected option IDs in the specified select drop-down</returns>
		public String[] GetSelectedIds(String selectLocator)
		{
			return commandProcessor.GetStringArray("getSelectedIds", new String[] {selectLocator,});
		}


		/// <summary>Gets option element ID for selected option in the specified select element.
		/// </summary>
		/// <param name="selectLocator">an <a href="#locators">element locator</a> identifying a drop-down menu</param>
		/// <returns>the selected option ID in the specified select drop-down</returns>
		public String GetSelectedId(String selectLocator)
		{
			return commandProcessor.GetString("getSelectedId", new String[] {selectLocator,});
		}


		/// <summary>Determines whether some option in a drop-down menu is selected.
		/// </summary>
		/// <param name="selectLocator">an <a href="#locators">element locator</a> identifying a drop-down menu</param>
		/// <returns>true if some option has been selected, false otherwise</returns>
		public bool IsSomethingSelected(String selectLocator)
		{
			return commandProcessor.GetBoolean("isSomethingSelected", new String[] {selectLocator,});
		}


		/// <summary>Gets all option labels in the specified select drop-down.
		/// </summary>
		/// <param name="selectLocator">an <a href="#locators">element locator</a> identifying a drop-down menu</param>
		/// <returns>an array of all option labels in the specified select drop-down</returns>
		public String[] GetSelectOptions(String selectLocator)
		{
			return commandProcessor.GetStringArray("getSelectOptions", new String[] {selectLocator,});
		}


		/// <summary>Gets the value of an element attribute.
		/// </summary>
		/// <param name="attributeLocator">an element locator followed by an</param>
		/// <returns>the value of the specified attribute</returns>
		public String GetAttribute(String attributeLocator)
		{
			return commandProcessor.GetString("getAttribute", new String[] {attributeLocator,});
		}


		/// <summary>Verifies that the specified text pattern appears somewhere on the rendered page shown to the user.
		/// </summary>
		/// <param name="pattern">a <a href="#patterns">pattern</a> to match with the text of the page</param>
		/// <returns>true if the pattern matches the text, false otherwise</returns>
		public bool IsTextPresent(String pattern)
		{
			return commandProcessor.GetBoolean("isTextPresent", new String[] {pattern,});
		}


		/// <summary>Verifies that the specified element is somewhere on the page.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		/// <returns>true if the element is present, false otherwise</returns>
		public bool IsElementPresent(String locator)
		{
			return commandProcessor.GetBoolean("isElementPresent", new String[] {locator,});
		}


		/// <summary>Determines if the specified element is visible. An
		/// element can be rendered invisible by setting the CSS "visibility"
		/// property to "hidden", or the "display" property to "none", either for the
		/// element itself or one if its ancestors.  This method will fail if
		/// the element is not present.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		/// <returns>true if the specified element is visible, false otherwise</returns>
		public bool IsVisible(String locator)
		{
			return commandProcessor.GetBoolean("isVisible", new String[] {locator,});
		}


		/// <summary>Determines whether the specified input element is editable, ie hasn't been disabled.
		/// This method will fail if the specified element isn't an input element.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a></param>
		/// <returns>true if the input element is editable, false otherwise</returns>
		public bool IsEditable(String locator)
		{
			return commandProcessor.GetBoolean("isEditable", new String[] {locator,});
		}


		/// <summary>Returns the IDs of all buttons on the page.
		/// 
		/// <p>If a given button has no ID, it will appear as "" in this array.</p>
		/// </summary>
		/// <returns>the IDs of all buttons on the page</returns>
		public String[] GetAllButtons()
		{
			return commandProcessor.GetStringArray("getAllButtons", new String[] {});
		}


		/// <summary>Returns the IDs of all links on the page.
		/// 
		/// <p>If a given link has no ID, it will appear as "" in this array.</p>
		/// </summary>
		/// <returns>the IDs of all links on the page</returns>
		public String[] GetAllLinks()
		{
			return commandProcessor.GetStringArray("getAllLinks", new String[] {});
		}


		/// <summary>Returns the IDs of all input fields on the page.
		/// 
		/// <p>If a given field has no ID, it will appear as "" in this array.</p>
		/// </summary>
		/// <returns>the IDs of all field on the page</returns>
		public String[] GetAllFields()
		{
			return commandProcessor.GetStringArray("getAllFields", new String[] {});
		}


		/// <summary>Returns the entire HTML source between the opening and
		/// closing "html" tags.
		/// </summary>
		/// <returns>the entire HTML source</returns>
		public String GetHtmlSource()
		{
			return commandProcessor.GetString("getHtmlSource", new String[] {});
		}


		/// <summary>Moves the text cursor to the specified position in the given input element or textarea.
		/// This method will fail if the specified element isn't an input element or textarea.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a> pointing to an input element or textarea</param>
		/// <param name="position">the numerical position of the cursor in the field; position should be 0 to move the position to the beginning of the field.  You can also set the cursor to -1 to move it to the end of the field.</param>
		public void SetCursorPosition(String locator,String position)
		{
			commandProcessor.DoCommand("setCursorPosition", new String[] {locator,position,});
		}


		/// <summary>Retrieves the text cursor position in the given input element or textarea; beware, this may not work perfectly on all browsers.
		/// 
		/// <p>Specifically, if the cursor/selection has been cleared by JavaScript, this command will tend to
		/// return the position of the last location of the cursor, even though the cursor is now gone from the page.  This is filed as <a href="http://jira.openqa.org/browse/SEL-243">SEL-243</a>.</p>
		/// This method will fail if the specified element isn't an input element or textarea, or there is no cursor in the element.
		/// </summary>
		/// <param name="locator">an <a href="#locators">element locator</a> pointing to an input element or textarea</param>
		/// <returns>the numerical position of the cursor in the field</returns>
		public Decimal GetCursorPosition(String locator)
		{
			return commandProcessor.GetNumber("getCursorPosition", new String[] {locator,});
		}


		/// <summary>Writes a message to the status bar and adds a note to the browser-side
		/// log.
		/// 
		/// <p>If logLevelThreshold is specified, set the threshold for logging
		/// to that level (debug, info, warn, error).</p><p>(Note that the browser-side logs will <i>not</i> be sent back to the
		/// server, and are invisible to the Client Driver.)</p>
		/// </summary>
		/// <param name="context">the message to be sent to the browser</param>
		/// <param name="logLevelThreshold">one of "debug", "info", "warn", "error", sets the threshold for browser-side logging</param>
		public void SetContext(String context,String logLevelThreshold)
		{
			commandProcessor.DoCommand("setContext", new String[] {context,logLevelThreshold,});
		}


		/// <summary>Returns the specified expression.
		/// 
		/// <p>This is useful because of JavaScript preprocessing.
		/// It is used to generate commands like assertExpression and waitForExpression.</p>
		/// </summary>
		/// <param name="expression">the value to return</param>
		/// <returns>the value passed in</returns>
		public String GetExpression(String expression)
		{
			return commandProcessor.GetString("getExpression", new String[] {expression,});
		}


		/// <summary>Runs the specified JavaScript snippet repeatedly until it evaluates to "true".
		/// The snippet may have multiple lines, but only the result of the last line
		/// will be considered.
		/// 
		/// <p>Note that, by default, the snippet will be run in the runner's test window, not in the window
		/// of your application.  To get the window of your application, you can use
		/// the JavaScript snippet <code>selenium.browserbot.getCurrentWindow()</code>, and then
		/// run your JavaScript in there</p>
		/// </summary>
		/// <param name="script">the JavaScript snippet to run</param>
		/// <param name="timeout">a timeout in milliseconds, after which this command will return with an error</param>
		public void WaitForCondition(String script,String timeout)
		{
			commandProcessor.DoCommand("waitForCondition", new String[] {script,timeout,});
		}


		/// <summary>Specifies the amount of time that Selenium will wait for actions to complete.
		/// 
		/// <p>Actions that require waiting include "open" and the "waitFor*" actions.</p>
		/// The default timeout is 30 seconds.
		/// </summary>
		/// <param name="timeout">a timeout in milliseconds, after which the action will return with an error</param>
		public void SetTimeout(String timeout)
		{
			commandProcessor.DoCommand("setTimeout", new String[] {timeout,});
		}


		/// <summary>Waits for a new page to load.
		/// 
		/// <p>You can use this command instead of the "AndWait" suffixes, "clickAndWait", "selectAndWait", "typeAndWait" etc.
		/// (which are only available in the JS API).</p><p>Selenium constantly keeps track of new pages loading, and sets a "newPageLoaded"
		/// flag when it first notices a page load.  Running any other Selenium command after
		/// turns the flag to false.  Hence, if you want to wait for a page to load, you must
		/// wait immediately after a Selenium command that caused a page-load.</p>
		/// </summary>
		/// <param name="timeout">a timeout in milliseconds, after which this command will return with an error</param>
		public void WaitForPageToLoad(String timeout)
		{
			commandProcessor.DoCommand("waitForPageToLoad", new String[] {timeout,});
		}

	}
}