/*
 * Copyright 2006 ThoughtWorks, Inc.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

// This file has been automatically generated via XSL
package com.thoughtworks.selenium;

/** The default implementation of the Selenium interface; <i>end users will primarily interact with this object.</i> */
public class DefaultSelenium implements Selenium {

	// This file has been automatically generated using XSL
	// This part of the file is hard-coded in the XSL
	protected CommandProcessor commandProcessor;
	/** Uses a CommandBridgeClient, specifying a server host/port, a command to launch the browser, and a starting URL for the browser.
     * 
     * <p><i>browserString</i> may be any one of the following:
     * <ul>
     * <li><code>*firefox [absolute path]</code> - Automatically launch a new Firefox process using a custom Firefox profile.
     * This profile will be automatically configured to use the Selenium Server as a proxy and to have all annoying prompts
     * ("save your password?" "forms are insecure" "make Firefox your default browser?" disabled.  You may optionally specify
     * an absolute path to your firefox executable, or just say "*firefox".  If no absolute path is specified, we'll look for
     * firefox.exe in a default location (normally c:\program files\mozilla firefox\firefox.exe), which you can override by
     * setting the Java system property <code>firefoxDefaultPath</code> to the correct path to Firefox.</li>
     * <li><code>*iexplore [absolute path]</code> - Automatically launch a new Internet Explorer process using custom Windows registry settings.
     * This process will be automatically configured to use the Selenium Server as a proxy and to have all annoying prompts
     * ("save your password?" "forms are insecure" "make Firefox your default browser?" disabled.  You may optionally specify
     * an absolute path to your iexplore executable, or just say "*iexplore".  If no absolute path is specified, we'll look for
     * iexplore.exe in a default location (normally c:\program files\internet explorer\iexplore.exe), which you can override by
     * setting the Java system property <code>iexploreDefaultPath</code> to the correct path to Internet Explorer.</li>
     * <li><code>/path/to/my/browser [other arguments]</code> - You may also simply specify the absolute path to your browser
     * executable, or use a relative path to your executable (which we'll try to find on your path).  <b>Warning:</b> If you
     * specify your own custom browser, it's up to you to configure it correctly.  At a minimum, you'll need to configure your
     * browser to use the Selenium Server as a proxy, and disable all browser-specific prompting.
     * </ul>
     * 
     * @param serverHost the host name on which the Selenium Server resides
     * @param serverPort the port on which the Selenium Server is listening
     * @param browserString the command string used to launch the browser, e.g. "*firefox", "*iexplore" or "c:\\program files\\internet explorer\\iexplore.exe"
     * @param browserURL the starting URL including just a domain name.  We'll start the browser pointing at the Selenium resources on this URL,
     * e.g. "http://www.google.com" would send the browser to "http://www.google.com/selenium-server/SeleneseRunner.html"
     */
    public DefaultSelenium(String serverHost, int serverPort, String browserStartCommand, String browserURL) {
        this.commandProcessor = new HttpCommandProcessor(serverHost, serverPort, browserStartCommand, browserURL);
    }
    
    /** Uses an arbitrary CommandProcessor */
    public DefaultSelenium(CommandProcessor processor) {
        this.commandProcessor = processor;
    }
    
    public void start() {
		try {
            commandProcessor.start();
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("Connection refused: connect") != -1) {
                throw new RuntimeException("Could not contact Selenium Server; have you started it?\n" + e.getMessage());
            }
        }
    }

    public void stop() {
        commandProcessor.stop();
    }

	// From here on, everything in this file has been auto-generated

	public void click(String locator) {
		commandProcessor.doCommand("click", new String[] {locator,});
	}

	public void fireEvent(String locator,String eventName) {
		commandProcessor.doCommand("fireEvent", new String[] {locator,eventName,});
	}

	public void keyPress(String locator,String keycode) {
		commandProcessor.doCommand("keyPress", new String[] {locator,keycode,});
	}

	public void keyDown(String locator,String keycode) {
		commandProcessor.doCommand("keyDown", new String[] {locator,keycode,});
	}

	public void keyUp(String locator,String keycode) {
		commandProcessor.doCommand("keyUp", new String[] {locator,keycode,});
	}

	public void mouseOver(String locator) {
		commandProcessor.doCommand("mouseOver", new String[] {locator,});
	}

	public void mouseDown(String locator) {
		commandProcessor.doCommand("mouseDown", new String[] {locator,});
	}

	public void type(String locator,String value) {
		commandProcessor.doCommand("type", new String[] {locator,value,});
	}

	public void check(String locator) {
		commandProcessor.doCommand("check", new String[] {locator,});
	}

	public void uncheck(String locator) {
		commandProcessor.doCommand("uncheck", new String[] {locator,});
	}

	public void select(String selectLocator,String optionLocator) {
		commandProcessor.doCommand("select", new String[] {selectLocator,optionLocator,});
	}

	public void addSelection(String locator,String optionLocator) {
		commandProcessor.doCommand("addSelection", new String[] {locator,optionLocator,});
	}

	public void removeSelection(String locator,String optionLocator) {
		commandProcessor.doCommand("removeSelection", new String[] {locator,optionLocator,});
	}

	public void submit(String formLocator) {
		commandProcessor.doCommand("submit", new String[] {formLocator,});
	}

	public void open(String url) {
		commandProcessor.doCommand("open", new String[] {url,});
	}

	public void selectWindow(String windowID) {
		commandProcessor.doCommand("selectWindow", new String[] {windowID,});
	}

	public void waitForPopUp(String windowID,String timeout) {
		commandProcessor.doCommand("waitForPopUp", new String[] {windowID,timeout,});
	}

	public void chooseCancelOnNextConfirmation() {
		commandProcessor.doCommand("chooseCancelOnNextConfirmation", new String[] {});
	}

	public void answerOnNextPrompt(String answer) {
		commandProcessor.doCommand("answerOnNextPrompt", new String[] {answer,});
	}

	public void goBack() {
		commandProcessor.doCommand("goBack", new String[] {});
	}

	public void refresh() {
		commandProcessor.doCommand("refresh", new String[] {});
	}

	public void close() {
		commandProcessor.doCommand("close", new String[] {});
	}

	public boolean isAlertPresent() {
		return commandProcessor.getBoolean("isAlertPresent", new String[] {});
	}

	public boolean isPromptPresent() {
		return commandProcessor.getBoolean("isPromptPresent", new String[] {});
	}

	public boolean isConfirmationPresent() {
		return commandProcessor.getBoolean("isConfirmationPresent", new String[] {});
	}

	public String getAlert() {
		return commandProcessor.getString("getAlert", new String[] {});
	}

	public String getConfirmation() {
		return commandProcessor.getString("getConfirmation", new String[] {});
	}

	public String getPrompt() {
		return commandProcessor.getString("getPrompt", new String[] {});
	}

	public String getLocation() {
		return commandProcessor.getString("getLocation", new String[] {});
	}

	public String getTitle() {
		return commandProcessor.getString("getTitle", new String[] {});
	}

	public String getBodyText() {
		return commandProcessor.getString("getBodyText", new String[] {});
	}

	public String getValue(String locator) {
		return commandProcessor.getString("getValue", new String[] {locator,});
	}

	public String getText(String locator) {
		return commandProcessor.getString("getText", new String[] {locator,});
	}

	public String getEval(String script) {
		return commandProcessor.getString("getEval", new String[] {script,});
	}

	public boolean isChecked(String locator) {
		return commandProcessor.getBoolean("isChecked", new String[] {locator,});
	}

	public String getTable(String tableCellAddress) {
		return commandProcessor.getString("getTable", new String[] {tableCellAddress,});
	}

	public String[] getSelectedLabels(String selectLocator) {
		return commandProcessor.getStringArray("getSelectedLabels", new String[] {selectLocator,});
	}

	public String getSelectedLabel(String selectLocator) {
		return commandProcessor.getString("getSelectedLabel", new String[] {selectLocator,});
	}

	public String[] getSelectedValues(String selectLocator) {
		return commandProcessor.getStringArray("getSelectedValues", new String[] {selectLocator,});
	}

	public String getSelectedValue(String selectLocator) {
		return commandProcessor.getString("getSelectedValue", new String[] {selectLocator,});
	}

	public String[] getSelectedIndexes(String selectLocator) {
		return commandProcessor.getStringArray("getSelectedIndexes", new String[] {selectLocator,});
	}

	public String getSelectedIndex(String selectLocator) {
		return commandProcessor.getString("getSelectedIndex", new String[] {selectLocator,});
	}

	public String[] getSelectedIds(String selectLocator) {
		return commandProcessor.getStringArray("getSelectedIds", new String[] {selectLocator,});
	}

	public String getSelectedId(String selectLocator) {
		return commandProcessor.getString("getSelectedId", new String[] {selectLocator,});
	}

	public boolean isSomethingSelected(String selectLocator) {
		return commandProcessor.getBoolean("isSomethingSelected", new String[] {selectLocator,});
	}

	public String[] getSelectOptions(String selectLocator) {
		return commandProcessor.getStringArray("getSelectOptions", new String[] {selectLocator,});
	}

	public String getAttribute(String attributeLocator) {
		return commandProcessor.getString("getAttribute", new String[] {attributeLocator,});
	}

	public boolean isTextPresent(String pattern) {
		return commandProcessor.getBoolean("isTextPresent", new String[] {pattern,});
	}

	public boolean isElementPresent(String locator) {
		return commandProcessor.getBoolean("isElementPresent", new String[] {locator,});
	}

	public boolean isVisible(String locator) {
		return commandProcessor.getBoolean("isVisible", new String[] {locator,});
	}

	public boolean isEditable(String locator) {
		return commandProcessor.getBoolean("isEditable", new String[] {locator,});
	}

	public String[] getAllButtons() {
		return commandProcessor.getStringArray("getAllButtons", new String[] {});
	}

	public String[] getAllLinks() {
		return commandProcessor.getStringArray("getAllLinks", new String[] {});
	}

	public String[] getAllFields() {
		return commandProcessor.getStringArray("getAllFields", new String[] {});
	}

	public String getHtmlSource() {
		return commandProcessor.getString("getHtmlSource", new String[] {});
	}

	public void setCursorPosition(String locator,String position) {
		commandProcessor.doCommand("setCursorPosition", new String[] {locator,position,});
	}

	public Number getCursorPosition(String locator) {
		return commandProcessor.getNumber("getCursorPosition", new String[] {locator,});
	}

	public void setContext(String context,String logLevelThreshold) {
		commandProcessor.doCommand("setContext", new String[] {context,logLevelThreshold,});
	}

	public String getExpression(String expression) {
		return commandProcessor.getString("getExpression", new String[] {expression,});
	}

	public void waitForCondition(String script,String timeout) {
		commandProcessor.doCommand("waitForCondition", new String[] {script,timeout,});
	}

	public void setTimeout(String timeout) {
		commandProcessor.doCommand("setTimeout", new String[] {timeout,});
	}

	public void waitForPageToLoad(String timeout) {
		commandProcessor.doCommand("waitForPageToLoad", new String[] {timeout,});
	}

}