using Root.Reports;
using System;
using System.Text;

// Creation date: 08.11.2002
// Checked: 31.10.2004
// Author: Otto Mayer (mot@root.ch)
// Version: 1.02

// Report.NET copyright 2002-2004 root-software ag, Brglen Switzerland - Otto Mayer, Stefan Spirig, all rights reserved
// This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation, version 2.1 of the License.
// This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details. You
// should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA www.opensource.org/licenses/lgpl-license.html

namespace ReportSamples {
  /// <summary>Flow Layout Manager Sample</summary>
  public class FlowLayoutManagerSample : Report {
    //------------------------------------------------------------------------------------------31.10.2004
    /// <summary>Creates this document</summary>
    protected override void Create() {
      FontDef fd = new FontDef(this, FontDef.StandardFont.Helvetica);
      FontProp fp_Title = new FontPropMM(fd, 7.8);
      fp_Title.bBold = true;
      FontProp fp = new FontPropMM(fd, 2.1);
      FontProp fp_Bold = new FontPropMM(fd, 2.1);
      fp_Bold.bBold = true;

      FlowLayoutManager flm = new FlowLayoutManager();
      flm.eNewContainer += new FlowLayoutManager.NewContainerEventHandler(NewContainer);
      flm.NewContainer();

      page_Cur.AddCB_MM(40, new RepString(fp_Title, "Flow Layout Manager Sample"));

      // generate random text
      StringBuilder sb = new StringBuilder(20000);
      Random random = new Random(unchecked((Int32)DateTime.Now.Ticks));
      for (Int32 iItem = 0;  iItem < 2000;  iItem++) {
        Int32 iLength = (Int32)Math.Sqrt(random.NextDouble() * 200) + 2;
        for (Int32 iWord = 0;  iWord < iLength;  iWord++) {
          sb.Append((Char)(random.Next((Int32)'z' - (Int32)'a' + 1) + (Int32)'a'));
        }
        sb.Append(" ");
        Int32 iOp = random.Next(40);
        if (iOp == 0) {
          flm.Add(new RepString(fp_Bold, sb.ToString()));  // append random text with bold font
          sb.Length = 0;
        }
        else if (iOp < 5) {
          flm.Add(new RepString(fp, sb.ToString()));  // append random text with normal font
          sb.Length = 0;
        }
        if (iOp == 1) {
          flm.NewLine(fp.rLineFeed * 1.5);  // new line
        }
      }

      // create footer
      foreach (Page page in enum_Page) {
        page.AddRightMM(185, 280, new RepString(fp, page.iPageNo.ToString() + " / " + iPageCount.ToString()));
      }
    }

    //------------------------------------------------------------------------------------------31.10.2004
    /// <summary>Creates a new container.</summary>
    /// <param name="oSender">Sender</param>
    /// <param name="ea">Event argument</param>
    /// <remarks>
    /// The first page has a caption . The following pages have no caption and therefore the table can be made higher.
    /// </remarks>
    private void NewContainer(Object oSender, FlowLayoutManager.NewContainerEventArgs ea) {
      new Page(this);
      if (page_Cur.iPageNo == 1) {  // create smaller container on first page
        StaticContainer sc = new StaticContainerMM(155, 215);
        page_Cur.AddMM(30, 55, sc);
        ea.flm.SetContainer(sc);
      }
      else {
        StaticContainer sc = new StaticContainerMM(155, 230);
        page_Cur.AddMM(30, 40, sc);
        ea.flm.SetContainer(sc);
      }
    }

  }
}
