using System;
using System.Collections;
using System.ComponentModel;
using System.Web;
using System.Web.SessionState;

// Creation date: 07.11.2004
// Checked: 08.11.2004
// Author: Otto Mayer (mot@root.ch)
// Version: 1.03

// Report.NET copyright 2002-2004 root-software ag, Brglen Switzerland - Otto Mayer, Stefan Spirig, all rights reserved
// This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License

// as published by the Free Software Foundation, version 2.1 of the License.

// This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of

// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details. You

// should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software

// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA www.opensource.org/licenses/lgpl-license.html

namespace ReportSamplesASP {
  /// <summary>Defines the methods, properties, and events common to all application objects within the Report.NET ASP Samples.</summary>
  /// <remarks>
  /// Instances of this class are created in the ASP.NET infrastructure, not by the user directly.
  /// One instance is used to process many requests in its lifetime but it can process only one at a time.
  /// Thus member variables can be used to store per-request data.
  /// </remarks>
  public class Global : System.Web.HttpApplication {
    /// <summary>Required designer variable.</summary>
    private System.ComponentModel.IContainer components = null;

    //------------------------------------------------------------------------------------------07.11.2004
    /// <summary>Initializes a new instance of the <b>Global</b> class.</summary>
    /// <remarks>The default constructor initializes any fields to their default values.</remarks>
    public Global() {
      InitializeComponent();
    }

    //------------------------------------------------------------------------------------------07.11.2004
    /// <summary>Application Start Event</summary>
    /// <param name="oSender">Sender</param>
    /// <param name="ea">Event argument</param>
    /// <remarks>Occurs when the application starts.</remarks>
    protected void Application_Start(Object oSender, EventArgs ea) {
    }
 
    //------------------------------------------------------------------------------------------07.11.2004
    /// <summary>Session Start Event</summary>
    /// <param name="oSender">Sender</param>
    /// <param name="ea">Event argument</param>
    /// <remarks>Occurs when a new session starts.</remarks>
    protected void Session_Start(Object oSender, EventArgs ea) {
    }

    //------------------------------------------------------------------------------------------07.11.2004
    /// <summary>Request Begin Event</summary>
    /// <param name="oSender">Sender</param>
    /// <param name="ea">Event argument</param>
    /// <remarks>Occurs as the first event in the HTTP pipeline chain of execution when ASP.NET responds to a request.</remarks>
    protected void Application_BeginRequest(Object oSender, EventArgs ea) {
    }

    //------------------------------------------------------------------------------------------07.11.2004
    /// <summary>Request End Event</summary>
    /// <param name="oSender">Sender</param>
    /// <param name="ea">Event argument</param>
    /// <remarks>Occurs as the last event to in the HTTP pipeline chain of execution when ASP.NET responds to a request.</remarks>
    protected void Application_EndRequest(Object oSender, EventArgs ea) {
    }

    //------------------------------------------------------------------------------------------07.11.2004
    /// <summary>Authenticate Request Event</summary>
    /// <param name="oSender">Sender</param>
    /// <param name="ea">Event argument</param>
    /// <remarks>Occurs when a security module has established the identity of the user.</remarks>
    protected void Application_AuthenticateRequest(Object oSender, EventArgs ea) {
    }

    //------------------------------------------------------------------------------------------07.11.2004
    /// <summary>Error Event</summary>
    /// <param name="oSender">Sender</param>
    /// <param name="ea">Event argument</param>
    /// <remarks>Occurs when an unhandled exception is thrown.</remarks>
    protected void Application_Error(Object oSender, EventArgs ea) {
    }

    //------------------------------------------------------------------------------------------07.11.2004
    /// <summary>Session End Event</summary>
    /// <param name="oSender">Sender</param>
    /// <param name="ea">Event argument</param>
    /// <remarks>Occurs when the session ends.</remarks>
    protected void Session_End(Object oSender, EventArgs ea) {
    }

    //------------------------------------------------------------------------------------------07.11.2004
    /// <summary>Application End Event</summary>
    /// <param name="oSender">Sender</param>
    /// <param name="ea">Event argument</param>
    /// <remarks>Occurs when the application ends.</remarks>
    protected void Application_End(Object oSender, EventArgs ea) {
    }
	
    //------------------------------------------------------------------------------------------07.11.2004
    #region Web Form Designer generated code
    /// <summary>Required method for Designer support - do not modify the contents of this method with the code editor.</summary>
    private void InitializeComponent() {    
      this.components = new System.ComponentModel.Container();
    }
    #endregion
  }
}
