using System;
using System.Collections;
using System.Diagnostics;
 
// Creation date: 22.04.2002
// Checked: xx.10.2002
// Author: Otto Mayer (mot@root.ch)
// Version: 1.01

// Report.NET copyright 2002-2004 root-software ag, Brglen Switzerland - O. Mayer, S. Spirig, R. Gartenmann, all rights reserved
// This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation, version 2.1 of the License.
// This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details. You
// should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA www.opensource.org/licenses/lgpl-license.html

namespace Root.Reports {
  /// <summary>PDF Page Data</summary>
  /// <remarks>This class contains data that is required to build the PDF page object.</remarks>
  /// <example>
  /// <code>
  /// 7 0 obj
  /// &lt;&lt;
  /// /Type /Page
  /// /Parent 6 0 R
  /// /Resources &lt;&lt;
  /// <b>/ProcSet [/PDF /Text]</b>
  /// <b>/Font &lt;&lt;</b>
  /// <b>/F4 4 0 R</b>
  /// <b>/F5 5 0 R</b>
  /// &gt;&gt;
  /// &gt;&gt;
  /// /MediaBox [0 0 595 842]
  /// /CropBox [0 0 595 842]
  /// /Rotate 0
  /// /Contents 8 0 R
  /// &gt;&gt;
  /// endobj
  /// </code>
  /// </example>
  internal class PdfPageData : PageData {
    /// <summary>ID of the PDF object</summary>
    private Int32 _iObjId;

    /// <summary>List of all font properties that are used on this page</summary>
    /// <remarks>This list is used in the PDF page object to specify the font resources.</remarks>
    /// <example>
    /// <code>
    /// 7 0 obj
    /// &lt;&lt;
    /// /Type /Page
    /// /Parent 6 0 R
    /// /Resources &lt;&lt;
    /// /ProcSet [/PDF /Text]
    /// /Font &lt;&lt;
    /// <b>/F4 4 0 R</b>
    /// <b>/F5 5 0 R</b>
    /// &gt;&gt;
    /// &gt;&gt;
    /// /MediaBox [0 0 595 842]
    /// /CropBox [0 0 595 842]
    /// /Rotate 0
    /// /Contents 8 0 R
    /// &gt;&gt;
    /// endobj
    /// </code>
    /// </example>
    private Hashtable ht_FontProp = new Hashtable(50);

    /// <summary>ProcSet PDF: painting and graphics state</summary>
    private Boolean _bProcSet_PDF = false;

    /// <summary>ProcSet Text: text</summary>
    private Boolean _bProcSet_Text = false;
    
    /// <summary>ProcSet ImageB: grayscale images or image masks</summary>
    private Boolean _bProcSet_ImageB = false;
    
    /// <summary>ProcSet ImageC: color images</summary>
    private Boolean _bProcSet_ImageC = false;

	//Added By TechnoGuru - jjborie@yahoo.fr - http://www.borie.org/
	/// <summary>ProcSet ImageI: color images</summary>
	private Boolean _bProcSet_ImageI = false;

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Creates a new PDF page data object.</summary>
    internal PdfPageData() {
      #if (DEBUG)
      StackFrame sf = new StackFrame(1);
      Debug.Assert(sf.GetMethod().Name == "pageData_CreateInstance");
      #endif
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary>ProcSet ImageB: grayscale images or image masks</summary>
    internal Boolean bProcSet_ImageB {
      get { return _bProcSet_ImageB; }
      set {
        #if (DEBUG)
        StackFrame sf = new StackFrame(1);
        Debug.Assert(sf.GetMethod().Name == "PrepareObjIdsForContainer");
        #endif
        _bProcSet_ImageB = value;
      }
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary>ProcSet ImageC: color images</summary>
    internal Boolean bProcSet_ImageC {
      get { return _bProcSet_ImageC; }
      set {
        #if (DEBUG)
        StackFrame sf = new StackFrame(1);
        Debug.Assert(sf.GetMethod().Name == "PrepareObjIdsForContainer");
        #endif
        _bProcSet_ImageC = value;
      }
    }

    //----------------------------------------------------------------------------------------------------x
    //Added By TechnoGuru - jjborie@yahoo.fr - http://www.borie.org/
    /// <summary>ProcSet ImageI: color images</summary>
    internal Boolean bProcSet_ImageI {
      get { return _bProcSet_ImageI; }
      set {
        #if (DEBUG)
        StackFrame sf = new StackFrame(1);
        Debug.Assert(sf.GetMethod().Name == "PrepareObjIdsForContainer");
        #endif
        _bProcSet_ImageI = value;
      }
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary>ProcSet PDF: painting and graphics state</summary>
    internal Boolean bProcSet_PDF {
      get { return _bProcSet_PDF; }
      set {
        #if (DEBUG)
        StackFrame sf = new StackFrame(1);
        Debug.Assert(sf.GetMethod().Name == "PrepareObjIdsForContainer");
        #endif
        _bProcSet_PDF = value;
      }
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary>ProcSet Text: text</summary>
    internal Boolean bProcSet_Text {
      get { return _bProcSet_Text; }
      set {
        #if (DEBUG)
        StackFrame sf = new StackFrame(1);
        Debug.Assert(sf.GetMethod().Name == "PrepareObjIdsForContainer");
        #endif
        _bProcSet_Text = value;
      }
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Collection of all font properties that are used on this page.</summary>
    internal ICollection icollection_FontProp {
      get {
        return ht_FontProp.Values;
      }
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary>ID of the PDF object</summary>
    internal Int32 iObjId {
      get { return _iObjId; }
      set {
        #if (DEBUG)
        StackFrame sf = new StackFrame(1);
        Debug.Assert(sf.GetMethod().Name == "PrepareObjIds");
        #endif
        _iObjId = value;
      }
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Registers the specified font properties for this page.</summary>
    /// <param name="fontProp">Font properties</param>
    /// <seealso cref="PdfPageData.ht_FontProp"/>
    /// <seealso cref="PdfFontPropData.pdfPageData_Registered"/>
    internal void RegisterFontProp(FontProp fontProp) {
      #if (DEBUG)
      StackFrame sf = new StackFrame(1);
      Debug.Assert(sf.GetMethod().Name == "PrepareObjIdsForContainer");
      #endif
      PdfFontPropData pdfFontPropData = (PdfFontPropData)fontProp.fontPropData;
      if (pdfFontPropData.pdfPageData_Registered != this) {
        ht_FontProp.Add(pdfFontPropData.sKey, fontProp);
        pdfFontPropData.pdfPageData_Registered = this;
      }
    }

  }
}
