using System;
//using System.Collections;
 
// Creation date: 11.10.2002
// Checked: xx.05.2002
// Author: Otto Mayer (mot@root.ch)
// Version: 1.01

// Report.NET copyright 2002-2004 root-software ag, Brglen Switzerland - O. Mayer, S. Spirig, R. Gartenmann, all rights reserved
// This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License
// as published by the Free Software Foundation, version 2.1 of the License.
// This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details. You
// should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA www.opensource.org/licenses/lgpl-license.html

namespace Root.Reports {
  /// <summary>Font Properties Data Class</summary>
  public abstract class FontPropData {
    //----------------------------------------------------------------------------------------------------x
    /// <summary>Creates a new font properties data object.</summary>
    internal FontPropData() {
    }

    //----------------------------------------------------------------------------------------------------x
    /// <summary></summary>
    internal protected abstract void Init();

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Gets the height of the font in 1/72 inches.</summary>
    /// <param name="fontProp">Font properties</param>
    /// <returns>Height of the font in 1/72 inches</returns>
    internal protected abstract Double rHeight(FontProp fontProp);

    //----------------------------------------------------------------------------------------------------x
    /// <summary>Gets the width of the specified text with this font in 1/72 inches.</summary>
    /// <param name="fontProp">Font properties</param>
    /// <param name="sText">Text</param>
    /// <returns>Width of the text in 1/72 inches</returns>
    internal protected abstract Double rWidth(FontProp fontProp, String sText);

  }
}